﻿// ---------------------------------------------------------------
// <copyright file="ContextMenuEx.cs" company="B33Rbaron">
//     Copyright (c) Daniel Birler.
//     Licensed under Microsoft Public License (Ms-PL).
// </copyright>
// <author>Daniel Birler</author>
// ---------------------------------------------------------------

namespace ChromeHost
{
  using System.Windows.Forms;

  /// <summary>
  /// An extended ContextMenu class.
  /// </summary>
  public sealed class ContextMenuEx : ContextMenu
  {
    /// <summary>
    /// Create the images for all menu items on the context menu.
    /// </summary>
    public void CreateMenuItemImages()
    {
      int count = this.MenuItems.Count;
      for (int i = 0; i < count; i++)
      {
        MenuItemEx menuItem = this.MenuItems[i] as MenuItemEx;
        if (menuItem != null)
        {
          menuItem.AddImageToMenuItem();
        }
      }
    }
  }
}