﻿// ---------------------------------------------------------------
// <copyright file="HotKeyModifierPair.cs" company="B33Rbaron">
//     Copyright (c) Daniel Birler.
//     Licensed under Microsoft Public License (Ms-PL).
// </copyright>
// <author>Daniel Birler</author>
// ---------------------------------------------------------------

namespace ChromeHost
{
  using System.Windows.Forms;

  /// <summary>
  /// A class for pairing hot keys and modifiers.
  /// </summary>
  internal sealed class HotKeyModifierPair
  {
    /// <summary>
    /// The id of the hotkey.
    /// </summary>
    private int hotKeyId = 0;

    /// <summary>
    /// The hotkey.
    /// </summary>
    private Keys hotKey = Keys.None;

    /// <summary>
    /// The hotkey modifier combination.
    /// </summary>
    private NativeMethods.MOD hotKeyModifier = NativeMethods.MOD.NONE;

    /// <summary>
    /// Initializes a new instance of the HotKeyModifierPair class.
    /// </summary>
    /// <param name="hotKeyId">The id of the hotkey.</param>
    /// <param name="hotKey">The hotkey.</param>
    /// <param name="hotKeyModifier">The hotkey modifier combination.</param>
    public HotKeyModifierPair(int hotKeyId, Keys hotKey, NativeMethods.MOD hotKeyModifier)
    {
      this.hotKeyId = hotKeyId;
      this.hotKey = hotKey;
      this.hotKeyModifier = hotKeyModifier;
    }

    /// <summary>
    /// Gets the hotkey id.
    /// </summary>
    public int HotKeyId
    {
      get { return this.hotKeyId; }
    }

    /// <summary>
    /// Gets the hotkey.
    /// </summary>
    public System.Windows.Forms.Keys HotKey
    {
      get { return this.hotKey; }
    }

    /// <summary>
    /// Gets the hotkey modifier combination.
    /// </summary>
    public NativeMethods.MOD HotKeyModifier
    {
      get { return this.hotKeyModifier; }
    }
  }
}