﻿// ---------------------------------------------------------------
// <copyright file="InfoForm.cs" company="B33Rbaron">
//     Copyright (c) Daniel Birler.
//     Licensed under Microsoft Public License (Ms-PL).
// </copyright>
// <author>Daniel Birler</author>
// ---------------------------------------------------------------

namespace ChromeHost
{
  using System;
  using System.Windows.Forms;
  using ChromeHost.Properties;

  /// <summary>
  /// An info form.
  /// </summary>
  public sealed partial class InfoForm : Form
  {
    /// <summary>
    /// Initializes a new instance of the InfoForm class.
    /// </summary>
    public InfoForm()
    {
      this.InitializeComponent();
      this.cbShowInfoOnStart.Checked = Settings.Default.ShowInfoOnStart;
    }

    /// <summary>
    /// Changes and saves showing this dialog on startup in the settings.
    /// </summary>
    /// <param name="sender">The source of the event.</param>
    /// <param name="e">A System.EventArgs that contains the event data.</param>
    private void ShowInfoOnStartCheckedChanged(object sender, EventArgs e)
    {
      Settings.Default.ShowInfoOnStart = this.cbShowInfoOnStart.Checked;
      Settings.Default.Save();
    }

    /// <summary>
    /// Occurs when the Ok Button is clicked.
    /// </summary>
    /// <param name="sender">The source of the event.</param>
    /// <param name="e">A System.EventArgs that contains the event data.</param>
    private void OkClicked(object sender, EventArgs e)
    {
      this.Close();
    }
  }
}