﻿// ---------------------------------------------------------------
// <copyright file="NameUrlPairManager.cs" company="B33Rbaron">
//     Copyright (c) Daniel Birler.
//     Licensed under Microsoft Public License (Ms-PL).
// </copyright>
// <author>Daniel Birler</author>
// ---------------------------------------------------------------

namespace ChromeHost
{
  using System;
  using System.Collections.ObjectModel;
  using ChromeHost.Properties;

  /// <summary>
  /// A class for managing name-url pairs.
  /// </summary>
  public sealed class NameUrlPairManager
  {
    /// <summary>
    /// This field is responsible for initializing the NameUrlPairManager class.
    /// </summary>
    private static readonly Lazy<NameUrlPairManager> Lazy = new Lazy<NameUrlPairManager>(() => new NameUrlPairManager());

    /// <summary>
    /// Prevents a default instance of the NameUrlPairManager class from being created.
    /// </summary>
    private NameUrlPairManager()
    {
    }

    /// <summary>
    /// Gets the one and only instance of the NameUrlPairManager class.
    /// </summary>
    public static NameUrlPairManager Instance
    {
      get { return Lazy.Value; }
    }

    /// <summary>
    /// Loads the name-url pairs from the settings file.
    /// </summary>
    /// <returns>A list of found name-url pairs.</returns>
    public Collection<NameUrlPair> LoadFromSettings()
    {
      Collection<NameUrlPair> nameUrlPairCollection = new Collection<NameUrlPair>();

      if (!string.IsNullOrEmpty(Settings.Default.MenuItemNameOne) &&
        !string.IsNullOrEmpty(Settings.Default.MenuItemUrlOne))
      {
        nameUrlPairCollection.Add(new NameUrlPair(Settings.Default.MenuItemNameOne, new Uri(Settings.Default.MenuItemUrlOne, UriKind.RelativeOrAbsolute)));
      }

      if (!string.IsNullOrEmpty(Settings.Default.MenuItemNameTwo) &&
        !string.IsNullOrEmpty(Settings.Default.MenuItemUrlTwo))
      {
        nameUrlPairCollection.Add(new NameUrlPair(Settings.Default.MenuItemNameTwo, new Uri(Settings.Default.MenuItemUrlTwo, UriKind.RelativeOrAbsolute)));
      }

      if (!string.IsNullOrEmpty(Settings.Default.MenuItemNameThree) &&
        !string.IsNullOrEmpty(Settings.Default.MenuItemUrlThree))
      {
        nameUrlPairCollection.Add(new NameUrlPair(Settings.Default.MenuItemNameThree, new Uri(Settings.Default.MenuItemUrlThree, UriKind.RelativeOrAbsolute)));
      }

      if (!string.IsNullOrEmpty(Settings.Default.MenuItemNameFour) &&
        !string.IsNullOrEmpty(Settings.Default.MenuItemUrlFour))
      {
        nameUrlPairCollection.Add(new NameUrlPair(Settings.Default.MenuItemNameFour, new Uri(Settings.Default.MenuItemUrlFour, UriKind.RelativeOrAbsolute)));
      }

      if (!string.IsNullOrEmpty(Settings.Default.MenuItemNameFive) &&
        !string.IsNullOrEmpty(Settings.Default.MenuItemUrlFive))
      {
        nameUrlPairCollection.Add(new NameUrlPair(Settings.Default.MenuItemNameFive, new Uri(Settings.Default.MenuItemUrlFive, UriKind.RelativeOrAbsolute)));
      }

      if (!string.IsNullOrEmpty(Settings.Default.MenuItemNameSix) &&
        !string.IsNullOrEmpty(Settings.Default.MenuItemUrlSix))
      {
        nameUrlPairCollection.Add(new NameUrlPair(Settings.Default.MenuItemNameSix, new Uri(Settings.Default.MenuItemUrlSix, UriKind.RelativeOrAbsolute)));
      }

      if (!string.IsNullOrEmpty(Settings.Default.MenuItemNameSeven) &&
        !string.IsNullOrEmpty(Settings.Default.MenuItemUrlSeven))
      {
        nameUrlPairCollection.Add(new NameUrlPair(Settings.Default.MenuItemNameSeven, new Uri(Settings.Default.MenuItemUrlSeven, UriKind.RelativeOrAbsolute)));
      }

      if (!string.IsNullOrEmpty(Settings.Default.MenuItemNameEight) &&
        !string.IsNullOrEmpty(Settings.Default.MenuItemUrlEight))
      {
        nameUrlPairCollection.Add(new NameUrlPair(Settings.Default.MenuItemNameEight, new Uri(Settings.Default.MenuItemUrlEight, UriKind.RelativeOrAbsolute)));
      }

      if (!string.IsNullOrEmpty(Settings.Default.MenuItemNameNine) &&
        !string.IsNullOrEmpty(Settings.Default.MenuItemUrlNine))
      {
        nameUrlPairCollection.Add(new NameUrlPair(Settings.Default.MenuItemNameNine, new Uri(Settings.Default.MenuItemUrlNine, UriKind.RelativeOrAbsolute)));
      }

      if (!string.IsNullOrEmpty(Settings.Default.MenuItemNameTen) &&
        !string.IsNullOrEmpty(Settings.Default.MenuItemUrlTen))
      {
        nameUrlPairCollection.Add(new NameUrlPair(Settings.Default.MenuItemNameTen, new Uri(Settings.Default.MenuItemUrlTen, UriKind.RelativeOrAbsolute)));
      }

      if (!string.IsNullOrEmpty(Settings.Default.MenuItemNameEleven) &&
        !string.IsNullOrEmpty(Settings.Default.MenuItemUrlEleven))
      {
        nameUrlPairCollection.Add(new NameUrlPair(Settings.Default.MenuItemNameEleven, new Uri(Settings.Default.MenuItemUrlEleven, UriKind.RelativeOrAbsolute)));
      }

      if (!string.IsNullOrEmpty(Settings.Default.MenuItemNameTwelve) &&
        !string.IsNullOrEmpty(Settings.Default.MenuItemUrlTwelve))
      {
        nameUrlPairCollection.Add(new NameUrlPair(Settings.Default.MenuItemNameTwelve, new Uri(Settings.Default.MenuItemUrlTwelve, UriKind.RelativeOrAbsolute)));
      }

      if (!string.IsNullOrEmpty(Settings.Default.MenuItemNameThirteen) &&
        !string.IsNullOrEmpty(Settings.Default.MenuItemUrlThirteen))
      {
        nameUrlPairCollection.Add(new NameUrlPair(Settings.Default.MenuItemNameThirteen, new Uri(Settings.Default.MenuItemUrlThirteen, UriKind.RelativeOrAbsolute)));
      }

      if (!string.IsNullOrEmpty(Settings.Default.MenuItemNameFourteen) &&
        !string.IsNullOrEmpty(Settings.Default.MenuItemUrlFourteen))
      {
        nameUrlPairCollection.Add(new NameUrlPair(Settings.Default.MenuItemNameFourteen, new Uri(Settings.Default.MenuItemUrlFourteen, UriKind.RelativeOrAbsolute)));
      }

      if (!string.IsNullOrEmpty(Settings.Default.MenuItemNameFifteen) &&
        !string.IsNullOrEmpty(Settings.Default.MenuItemUrlFifteen))
      {
        nameUrlPairCollection.Add(new NameUrlPair(Settings.Default.MenuItemNameFifteen, new Uri(Settings.Default.MenuItemUrlFifteen, UriKind.RelativeOrAbsolute)));
      }

      return nameUrlPairCollection;
    }

    /// <summary>
    /// Saves the name-url pairs to the settings file.
    /// </summary>
    /// <param name="nameUrlPairCollection">The name-url pair list to save.</param>
    public void SaveToSettings(Collection<NameUrlPair> nameUrlPairCollection)
    {
      if (nameUrlPairCollection.Count > 0)
      {
        Settings.Default.MenuItemNameOne = nameUrlPairCollection[0].Name;
        Settings.Default.MenuItemUrlOne = nameUrlPairCollection[0].Url.OriginalString;
      }
      else
      {
        Settings.Default.MenuItemNameOne = string.Empty;
        Settings.Default.MenuItemUrlOne = string.Empty;
      }

      if (nameUrlPairCollection.Count > 1)
      {
        Settings.Default.MenuItemNameTwo = nameUrlPairCollection[1].Name;
        Settings.Default.MenuItemUrlTwo = nameUrlPairCollection[1].Url.OriginalString;
      }
      else
      {
        Settings.Default.MenuItemNameTwo = string.Empty;
        Settings.Default.MenuItemUrlTwo = string.Empty;
      }

      if (nameUrlPairCollection.Count > 2)
      {
        Settings.Default.MenuItemNameThree = nameUrlPairCollection[2].Name;
        Settings.Default.MenuItemUrlThree = nameUrlPairCollection[2].Url.OriginalString;
      }
      else
      {
        Settings.Default.MenuItemNameThree = string.Empty;
        Settings.Default.MenuItemUrlThree = string.Empty;
      }

      if (nameUrlPairCollection.Count > 3)
      {
        Settings.Default.MenuItemNameFour = nameUrlPairCollection[3].Name;
        Settings.Default.MenuItemUrlFour = nameUrlPairCollection[3].Url.OriginalString;
      }
      else
      {
        Settings.Default.MenuItemNameFour = string.Empty;
        Settings.Default.MenuItemUrlFour = string.Empty;
      }

      if (nameUrlPairCollection.Count > 4)
      {
        Settings.Default.MenuItemNameFive = nameUrlPairCollection[4].Name;
        Settings.Default.MenuItemUrlFive = nameUrlPairCollection[4].Url.OriginalString;
      }
      else
      {
        Settings.Default.MenuItemNameFive = string.Empty;
        Settings.Default.MenuItemUrlFive = string.Empty;
      }

      if (nameUrlPairCollection.Count > 5)
      {
        Settings.Default.MenuItemNameSix = nameUrlPairCollection[5].Name;
        Settings.Default.MenuItemUrlSix = nameUrlPairCollection[5].Url.OriginalString;
      }
      else
      {
        Settings.Default.MenuItemNameSix = string.Empty;
        Settings.Default.MenuItemUrlSix = string.Empty;
      }

      if (nameUrlPairCollection.Count > 6)
      {
        Settings.Default.MenuItemNameSeven = nameUrlPairCollection[6].Name;
        Settings.Default.MenuItemUrlSeven = nameUrlPairCollection[6].Url.OriginalString;
      }
      else
      {
        Settings.Default.MenuItemNameSeven = string.Empty;
        Settings.Default.MenuItemUrlSeven = string.Empty;
      }

      if (nameUrlPairCollection.Count > 7)
      {
        Settings.Default.MenuItemNameEight = nameUrlPairCollection[7].Name;
        Settings.Default.MenuItemUrlEight = nameUrlPairCollection[7].Url.OriginalString;
      }
      else
      {
        Settings.Default.MenuItemNameEight = string.Empty;
        Settings.Default.MenuItemUrlEight = string.Empty;
      }

      if (nameUrlPairCollection.Count > 8)
      {
        Settings.Default.MenuItemNameNine = nameUrlPairCollection[8].Name;
        Settings.Default.MenuItemUrlNine = nameUrlPairCollection[8].Url.OriginalString;
      }
      else
      {
        Settings.Default.MenuItemNameNine = string.Empty;
        Settings.Default.MenuItemUrlNine = string.Empty;
      }

      if (nameUrlPairCollection.Count > 9)
      {
        Settings.Default.MenuItemNameTen = nameUrlPairCollection[9].Name;
        Settings.Default.MenuItemUrlTen = nameUrlPairCollection[9].Url.OriginalString;
      }
      else
      {
        Settings.Default.MenuItemNameTen = string.Empty;
        Settings.Default.MenuItemUrlTen = string.Empty;
      }

      if (nameUrlPairCollection.Count > 10)
      {
        Settings.Default.MenuItemNameEleven = nameUrlPairCollection[10].Name;
        Settings.Default.MenuItemUrlEleven = nameUrlPairCollection[10].Url.OriginalString;
      }
      else
      {
        Settings.Default.MenuItemNameEleven = string.Empty;
        Settings.Default.MenuItemUrlEleven = string.Empty;
      }

      if (nameUrlPairCollection.Count > 11)
      {
        Settings.Default.MenuItemNameTwelve = nameUrlPairCollection[11].Name;
        Settings.Default.MenuItemUrlTwelve = nameUrlPairCollection[11].Url.OriginalString;
      }
      else
      {
        Settings.Default.MenuItemNameTwelve = string.Empty;
        Settings.Default.MenuItemUrlTwelve = string.Empty;
      }

      if (nameUrlPairCollection.Count > 12)
      {
        Settings.Default.MenuItemNameThirteen = nameUrlPairCollection[12].Name;
        Settings.Default.MenuItemUrlThirteen = nameUrlPairCollection[12].Url.OriginalString;
      }
      else
      {
        Settings.Default.MenuItemNameThirteen = string.Empty;
        Settings.Default.MenuItemUrlThirteen = string.Empty;
      }

      if (nameUrlPairCollection.Count > 13)
      {
        Settings.Default.MenuItemNameFourteen = nameUrlPairCollection[13].Name;
        Settings.Default.MenuItemUrlFourteen = nameUrlPairCollection[13].Url.OriginalString;
      }
      else
      {
        Settings.Default.MenuItemNameFourteen = string.Empty;
        Settings.Default.MenuItemUrlFourteen = string.Empty;
      }

      if (nameUrlPairCollection.Count > 14)
      {
        Settings.Default.MenuItemNameFifteen = nameUrlPairCollection[14].Name;
        Settings.Default.MenuItemUrlFifteen = nameUrlPairCollection[14].Url.OriginalString;
      }
      else
      {
        Settings.Default.MenuItemNameFifteen = string.Empty;
        Settings.Default.MenuItemUrlFifteen = string.Empty;
      }

      Settings.Default.Save();
    }

    /// <summary>
    /// Returns the menu items based on what NameUrlPairs are stored in the settings.
    /// </summary>
    /// <returns>The created list of menu items created from the settings.</returns>
    public Collection<MenuItemEx> RetrieveMenuItems()
    {
      Collection<MenuItemEx> menuItemCollection = new Collection<MenuItemEx>();
      Collection<NameUrlPair> nameUrlPairCollection = this.LoadFromSettings();

      foreach (NameUrlPair nameUrlPair in nameUrlPairCollection)
      {
        MenuItemEx menuItem = new MenuItemEx(nameUrlPair.Name, Resources.MenuWebsite);
        menuItem.Tag = nameUrlPair;

        menuItemCollection.Add(menuItem);
      }

      return menuItemCollection;
    }
  }
}