﻿// ---------------------------------------------------------------
// <copyright file="Settings.cs" company="B33Rbaron">
//     Copyright (c) Daniel Birler.
//     Licensed under Microsoft Public License (Ms-PL).
// </copyright>
// <author>Daniel Birler</author>
// ---------------------------------------------------------------

namespace ChromeHost.Properties
{
  using System.ComponentModel;
  using System.Configuration;

  /// <summary>
  /// This class allows you to handle specific events on the settings class.
  /// </summary>
  internal sealed partial class Settings
  {
    /// <summary>
    /// Initializes a new instance of the Settings class.
    /// </summary>
    public Settings()
    {
      this.PropertyChanged += this.SettingsPropertyChanged;
      this.SettingChanging += this.SettingChangingEventHandler;
      this.SettingsLoaded += this.SettingsSettingsLoaded;
      this.SettingsSaving += this.SettingsSavingEventHandler;
    }

    /// <summary>
    /// Checks if the settings have to be upgraded.
    /// </summary>
    public static void CheckForUpgrade()
    {
      if (Settings.Default.IsUpgrade)
      {
        Settings.Default.Upgrade();
        Settings.Default.IsUpgrade = false;
        Settings.Default.ShowInfoOnStart = true;
        Settings.Default.Save();
      }
    }

    /// <summary>
    /// The PropertyChanged event is raised after a setting's value is changed.
    /// </summary>
    /// <param name="sender">The source of the event.</param>
    /// <param name="e">A System.ComponentModel.PropertyChangedEventArgs that contains the event data.</param>
    private void SettingsPropertyChanged(object sender, PropertyChangedEventArgs e)
    {
    }

    /// <summary>
    /// The SettingChanging event is raised before a setting's value is changed.
    /// </summary>
    /// <param name="sender">The source of the event.</param>
    /// <param name="e">A System.Configuration.SettingChangingEventArgs that contains the event data.</param>
    private void SettingChangingEventHandler(object sender, SettingChangingEventArgs e)
    {
    }

    /// <summary>
    /// The SettingsLoaded event is raised after the setting values are loaded.
    /// </summary>
    /// <param name="sender">The source of the event.</param>
    /// <param name="e">A System.Configuration.SettingsLoadedEventArgs that contains the event data.</param>
    private void SettingsSettingsLoaded(object sender, SettingsLoadedEventArgs e)
    {
    }

    /// <summary>
    /// The SettingsSaving event is raised before the setting values are saved.
    /// </summary>
    /// <param name="sender">The source of the event.</param>
    /// <param name="e">A System.ComponentModel.CancelEventArgs that contains the event data.</param>
    private void SettingsSavingEventHandler(object sender, CancelEventArgs e)
    {
    }
  }
}